#pragma once

#include <mail/sendbernar/composer/include/inline_handlers.h>
#include <mail/sendbernar/composer/include/remote_attachment.h>
#include <mail_getter/sanitizer/sanitizer_response_processor.h>

namespace sendbernar {

struct InlineClasses {
    InlineClasses(const InlineClassHandlers& handlers)
        : handlers_(handlers)
    { }

    RemoteAttachments& getAttachments();
    void process(std::string& text, InlineHandlerAttributes& attr, const mail_getter::SanitizerMarkup& markup);

private:
    std::shared_ptr<InlineClassHandler> findClassHandler(const std::string& className);

private:
    const InlineClassHandlers& handlers_;
    RemoteAttachments remoteAttachments_;

    const std::vector<std::string> EMPTY_VECTOR;
};

}
