#pragma once

#include <mail/sendbernar/composer/include/inline_handlers.h>

namespace sendbernar {

class InlineContent : public InlineClassHandler {
public:
    std::string getPrefix() override { return "yandex_inline_content_"; }
    int getAttachment(const std::string& classId, RemoteAttachment& att, InlineHandlerAttributes& attr) override;

    static bool parseId(const std::string& classId, std::string& st_id, std::string& hid, std::string& mid);
    static bool isValidStid(const std::string& st_id, const std::string& mid,
                            InlineHandlerAttributes::Stids& validStids, InlineHandlerAttributes::Stids& invalidStids,
                            MetadataPtr metadata);
    static MessageAccessPtr getMessageAccess(const std::string& mid, InlineHandlerAttributes::Messages& messages,
                                             MetadataPtr metadata, mail_getter::ServicePtr mailStorageService,
                                             const Recognizer::Wrapper& recognizer);

    template<class Part>
    static std::string getFilename(const Part& hs) {
        return !hs.fileName().empty() ? hs.fileName() : hs.name();
    }
};

}
