#pragma once

#include <mail/sendbernar/core/include/metadata.h>
#include <mail/sendbernar/composer/include/remote_attachment.h>
#include <mail/sendbernar/core/include/http.h>
#include <mail/sendbernar/core/include/logger.h>
#include <mail_getter/service.h>


namespace sendbernar {

struct InlineHandlerAttributes {
    using Stids = std::vector<std::string>;
    using Messages = std::map<std::string, MessageAccessPtr>;

    const std::string& host;
    MetadataPtr metadata;
    mail_getter::ServicePtr mailStorageService;
    ContextLogger logger;
    const http_getter::TypedClient& http;
    Stids validStids;
    Stids invalidStids;
    Messages messages;
    const Recognizer::Wrapper& recognizer;
    const mail_getter::attach_sid::KeyContainer& keyContainer;
};

struct InlineClassHandler {
    InlineClassHandler() { }
    virtual std::string getPrefix () { return ""; }
    virtual int getAttachment(const std::string&, RemoteAttachment&, InlineHandlerAttributes&) { return 0; }
    virtual ~InlineClassHandler() { }
};

using RemoteAttachments = std::vector<RemoteAttachment>;
using InlineClassHandlers = std::vector<std::shared_ptr<InlineClassHandler>>;

}
