#pragma once

#include <mail/sendbernar/composer/include/settings.h>
#include <mail/sendbernar/core/include/logger.h>

#include <mail/sendbernar/client/include/params.h>

#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/core/include/disk_attach_builder.h>
#include <mail/sendbernar/core/include/composed_message.h>
#include <mail/sendbernar/core/include/check_captcha_result.h>
#include <mail/sendbernar/core/include/compose_config.h>


namespace sendbernar {

class CommonHeaders;
class BodyAndAttaches;
class SidsAttachments;
class PartsJsonAttachments;
class MidsAttaches;
class SanitizerAndInlineAttaches;

class MailCompose {
    ComposeConfigPtr conf_;
    ContextLogger logger_;
    http_getter::TypedClientPtr httpPtr_;
    Account account_;
    MetadataPtr metadata_;
    params::CommonParams common_;
    DiskAttachBuilder diskAttaches_;
    LazySettings profile_;
    std::string sourceMidMessageId_;
    std::optional<Account> additionalAccount_;

    template<class Result, class Params>
    compose::Expected<Result> composeImpl(const Params& params, CheckCaptchaResult captchaStatus);

    mail_getter::ServicePtr servicePtr() const;

    template<class Params>
    CommonHeaders makeCommonHeaders(const Params& p, CheckCaptchaResult captchaStatus);
    template<class Params>
    BodyAndAttaches makeBodyAndAttaches(const Params& p);
    template<class Params>
    SidsAttachments makeSidsAttachments(const Params& p);
    template<class Params>
    PartsJsonAttachments makePartsJsonAttachments(const Params& p);
    template<class Params>
    MidsAttaches makeMidsAttaches(const Params& p);
    template<class Params, class Handlers>
    SanitizerAndInlineAttaches makeSanitizerAndInlineAttaches(const Params& p, const Handlers& h);

    VdirectPtr makeVdirect();

public:
    MailCompose(SendConfigurationPtr conf, ContextLogger logger,
                const http_getter::TypedClientPtr& httpPtr,
                const Account& account, MetadataPtr metadata,
                const std::string& sourceMidMessageId, const params::CommonParams& common,
                const std::optional<Account>& additionalAccount = std::nullopt)
        : conf_(std::make_shared<ComposeConfig>(*conf))
        , logger_(logger)
        , httpPtr_(httpPtr)
        , account_(account)
        , metadata_(metadata)
        , common_(common)
        , diskAttaches_(conf_->disk)
        , profile_(account_, metadata_, logger_)
        , sourceMidMessageId_(sourceMidMessageId)
        , additionalAccount_(additionalAccount)
    { }

    compose::Expected<compose::SaveDraftOrTemplate> compose(const params::SaveDraft& params);
    compose::Expected<compose::SaveDraftOrTemplate> compose(const params::SaveTemplate& params);
    compose::Expected<compose::SendDelayed> compose(const params::SendDelayed& params, CheckCaptchaResult captchaStatus);
    compose::Expected<compose::SendMessage> compose(const params::SendMessage& params, CheckCaptchaResult captchaStatus);
    compose::Expected<compose::SendMessage> compose(const params::SendShare& params);
    compose::Expected<compose::ComposeMessage> compose(const params::ComposeMessage& params);
    compose::Expected<compose::ComposeDraft> compose(const params::ComposeDraft& params);
};

}
