#pragma once

#include <mail/sendbernar/core/include/metadata.h>
#include <mail/sendbernar/core/include/logger.h>
#include <mail/sendbernar/core/include/cached_compose_result.h>
#include <mail/sendbernar/composer/include/rfc_message.h>
#include <mail/sendbernar/core/include/composed_message.h>
#include <mail/sendbernar/client/include/params.h>
#include <mail_getter/service.h>

namespace sendbernar {

class MidsAttaches {
    std::vector<macs::Mid> mids_;
    MetadataPtr metadata_;
    mail_getter::ServicePtr storageService_;
    const Recognizer::Wrapper& recognizer_;
    std::size_t attachmentsMaxSize_;
    ContextLogger logger_;

public:
    template<class Params>
    MidsAttaches(const Params& p, MetadataPtr metadata, mail_getter::ServicePtr storageService,
                 const Recognizer::Wrapper& recognizer, std::size_t attachmentsMaxSize, ContextLogger logger)
        : mids_(params::normalize(p).attaches.forward_mids.get_value_or({}))
        , metadata_(std::move(metadata))
        , storageService_(std::move(storageService))
        , recognizer_(recognizer)
        , attachmentsMaxSize_(attachmentsMaxSize)
        , logger_(std::move(logger))
    { }

    MidsAttaches(const MidsAttaches&) = default;
    MidsAttaches(MidsAttaches&&) = default;

    virtual ~MidsAttaches() { }

    virtual std::pair<macs::error_code, macs::MidsWithMimes> getMimes() const {
        return metadata_->getMimes(mids_);
    }

    virtual MessageAccessPtr messageAccess(mail_getter::MidStidMime midStidMime) const {
        return storageService_->createMessageAccess(mail_getter::getMessageAccessParams(std::move(midStidMime)),
                                                    recognizer_);
    }

    const std::vector<macs::Mid>& mids() const {
        return mids_;
    }

    ComposeResult apply(RfcMessage& m, std::size_t& totalAttachmentsSize) const;
};

}
