#pragma once

#include <mail/sendbernar/core/include/cached_compose_result.h>
#include <mail/sendbernar/composer/include/rfc_message.h>
#include <mail/sendbernar/core/include/composed_message.h>
#include <mail/sendbernar/client/include/params.h>
#include <mail_getter/service.h>
#include <mail_getter/content_type.h>
#include <mail/sendbernar/composer/include/inline_classes.h>
#include <mail/sendbernar/core/include/metadata.h>
#include <mail/sendbernar/core/include/logger.h>

namespace sendbernar {

class PartsJsonAttachments {
    params::Parts partsJson_;
    mail_getter::ServicePtr storageService_;
    const IContentTypeDetector& detector_;
    const Recognizer::Wrapper& recognizer_;
    ContextLogger logger_;
    MetadataPtr metadata_;
    std::size_t attachmentsMaxSize_;

public:
    template<class Params>
    PartsJsonAttachments(const Params& p, mail_getter::ServicePtr storageService, const IContentTypeDetector& detector,
                         const Recognizer::Wrapper& recognizer, MetadataPtr metadata,
                         std::size_t attachmentsMaxSize, ContextLogger logger)
        : partsJson_(params::normalize(p).attaches.parts_json.get_value_or({}))
        , storageService_(std::move(storageService))
        , detector_(detector)
        , recognizer_(recognizer)
        , logger_(logger)
        , metadata_(std::move(metadata))
        , attachmentsMaxSize_(attachmentsMaxSize)
    { }

    PartsJsonAttachments(const PartsJsonAttachments&) = default;
    PartsJsonAttachments(PartsJsonAttachments&&) = default;

    virtual ~PartsJsonAttachments() { }

    static std::string nameOrFilename(const std::string& name, const std::string& filename) {
        return !filename.empty() ? filename : name;
    }

    virtual boost::optional<compose::Attachment> getPartAttachment(MessageAccessPtr ma, RfcMessage& m,
                                                                           const std::string& oldHid,
                                                                           const RemoteAttachments& attLst) const;

    virtual CachedComposeResult addMessageAttachments(RfcMessage& msg,
                                                      std::vector<compose::Attachment>& attachments,
                                                      std::size_t& totalAttachmentsSize,
                                                      const std::string& mid, const std::vector<std::string>& parts,
                                                      const std::vector<RemoteAttachment>& attLst) const;

    virtual MessageAccessPtr messageAccess(const macs::Mid& mid) const;

    CachedComposeResult apply(RfcMessage& m,
                              std::vector<compose::Attachment>& attachments,
                              std::size_t& totalAttachmentsSize,
                              const std::vector<RemoteAttachment>& attLst) const;
};

}
