#pragma once

#include <pa/async.h>
#include <pa/stimer.h>


namespace sendbernar {

struct ProfilerWrapper {
    std::string service_;
    std::string suid_;
    pa::async_profiler profiler;
    pa::stimer_t timer;

    ProfilerWrapper(const std::string& service, const std::string& suid)
        : service_(service), suid_(suid)
    {
        timer.start();
    }

    void step(const std::string& msg) {
        profiler.add(pa::etc, service_, msg, suid_, timer.stop());
        timer.start();
    }

    void last(const std::string& msg) {
        profiler.add(pa::etc, service_, msg, suid_, timer.stop());
    }
};

}
