#pragma once

#include <string>
#include <mail/sendbernar/composer/include/rfc_message.h>
#include <mail/sendbernar/core/include/cached_compose_result.h>
#include <mail/sendbernar/core/include/recipients_repository.h>


namespace sendbernar {
namespace detail {
template<class T>
struct Saving;

template<>
struct Saving<params::SaveDraft>: public std::true_type { };

template<>
struct Saving<params::SaveTemplate>: public std::true_type { };

template<>
struct Saving<params::ComposeDraft>: public std::true_type { };

template<>
struct Saving<params::SendDelayed>: public std::false_type { };

template<>
struct Saving<params::SendMessage>: public std::false_type { };

template<>
struct Saving<params::SendShare>: public std::false_type { };

template<>
struct Saving<params::ComposeMessage>: public std::false_type { };

}

class RecipientsHeaders {
    std::string to_;
    std::string cc_;
    std::string bcc_;
    bool nosend_ = true;

    RecipientsRepository recipients_;

public:
    template<class Params>
    RecipientsHeaders(const std::set<std::string>& domainsNotToLowercase,
                      unsigned maxRecipients,
                      const Params& p)
        : to_(params::normalize(p).recipients.to.get_value_or(""))
        , cc_(params::normalize(p).recipients.cc.get_value_or(""))
        , bcc_(params::normalize(p).recipients.bcc.get_value_or(""))
        , nosend_(detail::Saving<Params>::value)
        , recipients_(domainsNotToLowercase, maxRecipients)
    { }

    RecipientsHeaders(const RecipientsHeaders&) = default;
    RecipientsHeaders(RecipientsHeaders&&) = default;

    CachedComposeResult apply(RfcMessage& message);

    const RecipientsRepository& recipients() const {
        return recipients_;
    }
};

}
