#pragma once

#include <mimeparser/build_msg.h>
#include <mail_getter/mime_type.h>
#include <mail/sendbernar/composer/include/remote_attachment.h>
#include <mail_getter/MessageAccessDefinitions.h>


namespace sendbernar {

struct RfcMessage;
using RfcMessagePtr = std::shared_ptr<RfcMessage>;

enum class ContentTypeEncoding {
    SevenBit,
    EightBit,
    Base64
};

std::string toString(ContentTypeEncoding cte);

struct MultipartRelaxedMessage {
    virtual ~MultipartRelaxedMessage() { }

    virtual MimeParser::Hid addRemoteAttach(MimeType mType, const RemoteAttachment& attach) = 0;
};

using MultipartRelaxedMessagePtr = std::shared_ptr<MultipartRelaxedMessage>;

struct RfcMessage {
    message msg;

    RfcMessage()
        : msg("US-ASCII")
    { }

    RfcMessage(const RfcMessage&) = default;
    RfcMessage(RfcMessage&&) = default;

    virtual ~RfcMessage() { }

    virtual void addUtf8Header(const std::string& name, const std::string& value);
    virtual void addHeader(const std::string& name, const std::string& value);
    virtual void addEmailHeader(const std::string& name, const std::string& value);
    virtual void addEmailHeaderDraft(const std::string& name, const std::string& value);
    virtual void addMessageId(const std::string& id);
    virtual void addBody(const std::string& text, ContentTypeEncoding cte, bool isTextHtml);

    virtual void setUtf8();

    virtual MimeParser::Hid addPart(RfcMessagePtr part);
    virtual MultipartRelaxedMessagePtr addRelatedPart(RfcMessagePtr part);

    virtual MimeParser::Hid addBase64File(MimeType mType, const std::string& body, const std::string& filename);
    virtual MimeParser::Hid addHid(MimeType mType, const MetaPart& part, const std::string& text, const std::string& name);
    virtual void addNarodAttach(const std::string& text, ContentTypeEncoding cte);
    virtual MimeParser::Hid addRfc822Part(const std::string& text);

    virtual std::string text();
};

}
