#pragma once

#include <optional>

#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/core/include/http.h>
#include <mail_getter/sanitizer/sanitizer_response_processor.h>


namespace sendbernar {

struct Sanitizer {
    virtual ~Sanitizer() = default;

    virtual std::optional<mail_getter::SanitizerParsedResponse> sanitize(std::string body, const std::string& messageId) = 0;
};

using SanitizerPtr = std::shared_ptr<Sanitizer>;

SanitizerPtr makeSanitizer(const std::string& uid, const std::string& requestId,
                           const SanitizerConfiguration& config, http_getter::TypedClientPtr http);

}
