#pragma once

#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/core/include/metadata.h>

namespace sendbernar {

Settings::Values userSettings(const sendbernar::Account& account, MetadataPtr metadata, ContextLogger logger);

struct LazySettings {
    LazySettings(const sendbernar::Account& acc, MetadataPtr m,
                 ContextLogger logger, std::optional<Settings::Values> vals = std::nullopt)
        : account_(acc)
        , metadata_(std::move(m))
        , logger_(std::move(logger))
        , values_(std::move(vals))
    {}

    Settings::Values& get() {
        if (!values_) {
            values_ = userSettings(account_, metadata_, logger_);
        }
        return *values_;
    }

private:
    const sendbernar::Account& account_;
    MetadataPtr metadata_;
    ContextLogger logger_;
    std::optional<Settings::Values> values_;
};

}
