#pragma once

#include <mail/sendbernar/core/include/cached_compose_result.h>
#include <mail/sendbernar/composer/include/rfc_message.h>
#include <mail/sendbernar/core/include/composed_message.h>
#include <mail/sendbernar/client/include/params.h>
#include <mail_getter/AttachShieldCrypto.h>
#include <mail_getter/service.h>
#include <mail_getter/content_type.h>
#include <mail/sendbernar/core/include/logger.h>

namespace sendbernar {

class SidsAttachments {
    std::vector<std::string> sids_;
    const mail_getter::attach_sid::KeyContainer& keyContainer_;
    mail_getter::ServicePtr storageService_;
    const IContentTypeDetector& detector_;
    const Recognizer::Wrapper& recognizer_;
    ContextLogger logger_;

public:
    using VectorOfAttachments = mail_getter::AttachmentStorage::VectorOfAttachments;

    template<class Params>
    SidsAttachments(const Params& p, const mail_getter::attach_sid::KeyContainer& keyContainer,
                    mail_getter::ServicePtr storageService, const IContentTypeDetector& detector,
                    const Recognizer::Wrapper& recognizer, ContextLogger logger)
        : sids_(params::normalize(p).attaches.uploaded_attach_stids.get_value_or({}))
        , keyContainer_(keyContainer)
        , storageService_(std::move(storageService))
        , detector_(detector)
        , recognizer_(recognizer)
        , logger_(std::move(logger))
    { }

    SidsAttachments(const SidsAttachments&) = default;
    SidsAttachments(SidsAttachments&&) = default;

    virtual ~SidsAttachments() { }

    virtual std::vector<compose::Attachment> getStorageAttachments(RfcMessage& m, const VectorOfAttachments& attachments) const;

    virtual std::pair<int, VectorOfAttachments> getIds(const std::vector<macs::Stid>& ids) const;

    virtual macs::Stid decryptId(const std::string& sid) const;

    CachedComposeResult apply(RfcMessage& m, std::vector<compose::Attachment>& attachments,
                              std::size_t& totalAttachmentsSize);
};

}
