#pragma once

#include <mimeparser/build_msg.h>
#include <mail/sendbernar/core/include/cached_compose_result.h>
#include <mail/sendbernar/core/include/recipients_repository.h>
#include <mail/sendbernar/core/include/composed_message.h>

namespace sendbernar {

#define GETTER(NAME,TYPE) \
    TYPE NAME() const { \
        return NAME##_; \
    }

#define MODIFIER(NAME,TYPE) \
    SystemMailComposer & NAME (TYPE NAME) { \
        NAME##_ = NAME; \
        return *this; \
    }

class SystemMailComposer {
public:
    using Expected = yamail::expected<compose::SystemMessage, ComposeResult>;

    SystemMailComposer()
        : strictCharset_(false)
        , messageMaxSize_(0)
    { }

    GETTER( fromMailbox, const std::string & )
    const std::string & getMessage() const;

    Expected compose();

    MODIFIER( messageMaxSize, size_t )
    MODIFIER( strictCharset, bool )
    MODIFIER( desiredCharset, const std::string & )
    MODIFIER( subtype, const std::string & )
    MODIFIER( fromName, const std::string & )
    MODIFIER( fromMailbox, const std::string & )
    MODIFIER( to, const std::string & )
    MODIFIER( cc, const std::string & )
    MODIFIER( bcc, const std::string & )
    MODIFIER( subject, const std::string & )
    MODIFIER( body, const std::string & )
    MODIFIER( messageId, const std::string & )
    MODIFIER( inReplyTo, const std::string & )

    const RecipientsRepository& recipients() const {
        return recipients_;
    }

    std::string messageId();

protected:
    GETTER( messageMaxSize, size_t )
    GETTER( strictCharset, bool )
    GETTER( desiredCharset, const std::string & )
    GETTER( subtype, const std::string & )
    GETTER( to, const std::string & )
    GETTER( cc, const std::string & )
    GETTER( bcc, const std::string & )
    GETTER( subject, const std::string & )
    GETTER( body, const std::string & )
    GETTER( inReplyTo, const std::string & )

    std::string from();

    void addHeader(const std::string &header);
    void appendMessageText(message &m);

    bool addHeader(message &m, const std::string &name, std::string value);
    bool addEmailHeader(message &m, const std::string &name, std::string value);
    void addCommonHeaders(message &m);
    void addReceivedHeader(message &m);
    void addDateHeader(message &m);
    CachedComposeResult addBody(message &m,
            const std::string &body, const std::string &subtype);
    CachedComposeResult setRecipients(message &m, const std::string &to,
            const std::string &cc, const std::string &bcc);

    bool checkLimits();

private:
    std::string getReceivedDate();

    bool strictCharset_;
    size_t messageMaxSize_;
    std::string desiredCharset_;
    std::string subtype_;
    std::string fromMailbox_;
    std::string fromName_;
    std::string to_;
    std::string cc_;
    std::string bcc_;
    std::string subject_;
    std::string body_;
    std::string messageId_;
    std::string inReplyTo_;

    std::string messageText_;
    RecipientsRepository recipients_;
    Recipients rcpt_;
};

#undef MODIFIER
#undef GETTER

}
