#include <mail/sendbernar/composer/include/inline_classes.h>


namespace sendbernar {

std::shared_ptr<InlineClassHandler> InlineClasses::findClassHandler(const std::string& className) {
    for (InlineClassHandlers::const_iterator it = handlers_.begin(); it != handlers_.end(); ++it) {
        auto icHandler = *it;
        const std::string prefix = icHandler->getPrefix();
        if (className.compare(0, prefix.size(), prefix) == 0) {
            return icHandler;
        }
    }
    return 0;
}

RemoteAttachments& InlineClasses::getAttachments() {
    return remoteAttachments_;
}

void InlineClasses::process(std::string& text, InlineHandlerAttributes& attr, const mail_getter::SanitizerMarkup& markup) {
    for (mail_getter::SanitizerMarkup::const_reverse_iterator it = markup.rbegin(); it != markup.rend(); ++it) {
        const mail_getter::SanitizerMarkupEntry &entry = *it;
        if (entry.type == mail_getter::SanitizerMarkupType_Class && entry.classValue) {
            auto classHandler = findClassHandler(entry.classValue.get());
            if (classHandler) {
                RemoteAttachment att;
                const std::string prefix = classHandler->getPrefix();
                const std::string id = entry.classValue.get().substr(prefix.size());

                try {
                    if (classHandler->getAttachment(id, att, attr)) {
                        remoteAttachments_.push_back(att);
                        text.replace(entry.position.dataStart, entry.position.dataLength, "cid:" + att.cid);
                    } else {
                        text.erase(entry.position.attributeStart, entry.position.attributeLength);
                    }
                } catch (const std::exception& e) {
                    text.erase(entry.position.attributeStart, entry.position.attributeLength);
                    LOGDOG_(attr.logger, notice, log::where_name="inline_classes", log::message="cannot get attachment",
                            log::exception=e);
                }
            }
        }
    }
}

}
