#include <mail/sendbernar/composer/include/inline_from_verstka.h>
#include <mail_getter/mime_type.h>

#include <mimeparser/build_msg.h>

namespace sendbernar {

bool InlineFromVerstka::stidIsOk( const std::string & stid ) const {
    return !stid.empty();
}

std::string InlineFromVerstka::decryptStid(const std::string& classId, InlineHandlerAttributes& attr) const {
    return mail_getter::decryptId(classId, attr.keyContainer);
}

std::string InlineFromVerstka::generateCid() const {
    return generate_content_id();
}

int InlineFromVerstka::getAttachment(const std::string & classId,
        RemoteAttachment & att, InlineHandlerAttributes & attr) {
    using namespace mail_getter;
    std::string stid = decryptStid(classId, attr);

    if ( !stidIsOk( stid ) ) {
        return 0;
    }

    auto attachmentStorage = attr.mailStorageService->createAttachmentStorage("");
    std::vector<std::string> ids(1, stid);
    AttachmentStorage::VectorOfAttachments attach;
    if ( attachmentStorage->get(ids, attach) != 0 ) {
        return 0;
    }

    const AbstractAttachment& content = *attach.front();

    att.name = content.getFilename();
    MimeType mime(content.getContentType());
    att.disposition = "inline";
    att.encoding = "base64";
    att.cid = generateCid();
    att.original_url = "http://" + attr.host + "/message_part/" + att.name
            + "?sid=" + classId + "&amp;name=" + att.name;
    att.body = content.getBody();
    return 1;
}

}
