#include <mail/sendbernar/composer/include/inline_processor.h>
#include <mail/sendbernar/composer/include/inline_classes.h>

namespace sendbernar {

std::optional<InlineProcessor::Response> InlineProcessor::process(std::string body, const std::string& messageId) {
    mail_getter::SanitizerParsedResponse resp;
    RemoteAttachments attachments;
    if (!body.empty()) {
        if (const auto sResp = sanitize->sanitize(std::move(body), messageId); sResp == std::nullopt) {
            return std::nullopt;
        } else {
            resp = *sResp;
        }

        InlineClasses classes(inlineHandlers);
        InlineHandlerAttributes attr = { host, metadata, storageService, logger, *httpPtr, {}, {}, {}, recognizer, keyContainer };
        classes.process(resp.html, attr, resp.markup);
        attachments = classes.getAttachments();

        for (std::size_t i = 0; i < attachments.size(); i++) {
            if (attachments[i].name.empty()) {
                attachments[i].name = "image" + std::to_string(i + 1);
            }
        }
    }

    LOGDOG_(logger, debug, log::inline_attaches=attachments.size());

    return InlineProcessor::Response{std::move(attachments), std::move(resp.html)};
}

}
