#include <mail/sendbernar/composer/include/mids_attaches.h>

namespace sendbernar {

ComposeResult MidsAttaches::apply(RfcMessage& m, std::size_t& totalAttachmentsSize) const {
    macs::error_code error;
    macs::MidsWithMimes midsStidsMimes;

    std::tie(error, midsStidsMimes) = getMimes();

    if (error) {
        LOGDOG_(logger_, error, log::where_name="MidsAttaches", log::error_code=error);
        if (error == macs::error::input) {
            throw std::runtime_error("invalid input: " + error.message());
        } else {
            throw std::runtime_error("error: " + error.message());
        }
    }
    if (midsStidsMimes.size() != mids_.size()) {
        LOGDOG_(logger_, notice, log::where_name="MidsAttaches",
                log::message=std::string("stids and mids don't match: ") + std::to_string(mids_.size()) +
                " mids vs " + std::to_string(midsStidsMimes.size()) + " stids");
    }
    for (auto& midStidMime: midsStidsMimes) {
        const MessageAccessPtr ma = messageAccess(std::move(midStidMime));

        const std::string wh = ma->getWhole();
        totalAttachmentsSize += wh.size();
        LOGDOG_(logger_, debug, log::attached_message_size=wh.size());
        if (totalAttachmentsSize > attachmentsMaxSize_) {
            return ComposeResult::ATTACHMENT_TOO_BIG;
        }
        m.addRfc822Part(wh);
    }

    return ComposeResult::DONE;
}

}
