#include <mail/sendbernar/composer/include/parts_json.h>
#include <mail_getter/UTFizer.h>
#include <butil/StrUtils/Encoding.h>
#include <mail/sendbernar/composer/include/attach_helpers.h>

namespace sendbernar {

boost::optional<compose::Attachment> PartsJsonAttachments::getPartAttachment(
        MessageAccessPtr ma, RfcMessage& m,
        const std::string& oldHid,
        const RemoteAttachments& attLst) const {

    MetaPart attr = ma->getHeaderStruct(oldHid);
    if (!attr.cid().empty()) {
        const auto it = std::find_if(attLst.begin(), attLst.end(), [&](const auto& el) {
            return el.cid == attr.cid();
        });

        if (it != attLst.end()) {
            return boost::none;
        }
    }

    std::string name = nameOrFilename(attr.name(), attr.fileName());

    std::string cont = ma->getBody(oldHid);
    Encoding::decode(attr.encoding(), cont);

    MimeType mType = detector_.detect(name, cont);

    Encoding::encode(attr.encoding(), cont, true);

    UTFizer::process(recognizer_, "utf-8", name);
    MimeParser::Hid hid = m.addHid(mType, attr, cont, name);

    return compose::Attachment {
        .hid_ = hid.toString(),
        .oldHid_ = oldHid,
        .contentType_ = mType.toString(),
        .fileName_ = name,
        .size_ = cont.size(),
        .hash_ = calcHashAttachment(cont, name),
    };
}

MessageAccessPtr PartsJsonAttachments::messageAccess(const macs::Mid& mid) const {
    return storageService_->createMessageAccess(
                metadata_->getMessageAccessWithWindatParams(mid),
                recognizer_
    );
}

CachedComposeResult PartsJsonAttachments::addMessageAttachments(RfcMessage& msg,
                                                                std::vector<compose::Attachment>& attachments,
                                                                std::size_t& totalAttachmentsSize,
                                                                const std::string& mid,
                                                                const std::vector<std::string>& parts,
                                                                const std::vector<RemoteAttachment>& attLst) const {

    try {
        MessageAccessPtr ma = messageAccess(mid);

        for (const auto& hid : parts) {
            if (auto attach = getPartAttachment(ma, msg, hid, attLst)) {
                totalAttachmentsSize += attach->size_;
                LOGDOG_(logger_, notice, log::attach_size = attach->size_);
                attachments.emplace_back(std::move(*attach));
                if (totalAttachmentsSize > attachmentsMaxSize_) {
                    return ComposeResult::ATTACHMENT_TOO_BIG;
                }
            }
        }

        return ComposeResult::DONE;
    } catch (const std::exception& ex) {
        LOGDOG_(logger_, notice, log::exception=ex);
    }

    return ComposeResult::PARTS_JSON_INVALID;
}

CachedComposeResult PartsJsonAttachments::apply(RfcMessage& m,
                                                std::vector<compose::Attachment>& attachments,
                                                std::size_t& totalAttachmentsSize,
                                                const std::vector<RemoteAttachment>& attLst) const {

    if (!partsJson_.empty()) {
        std::map<macs::Mid, std::vector<std::string>> parts;

        for (const auto& part: partsJson_) {
            parts[part.mid].push_back(part.hid);
        }

        for (const auto& part: parts) {
            CachedComposeResult result = addMessageAttachments(m, attachments, totalAttachmentsSize,
                                                               part.first, part.second, attLst);
            if (!result.succeeded()) {
                return result;
            }
        }
    }

    return ComposeResult::DONE;
}

}
