#include <mail/sendbernar/composer/include/recipients_headers.h>


namespace sendbernar {

CachedComposeResult RecipientsHeaders::apply(RfcMessage& m) {
    if (nosend_) {
        if (!to_.empty()) {
            m.addEmailHeaderDraft("To", to_);
        }
        if (!cc_.empty()) {
            m.addEmailHeaderDraft("Cc", cc_);
        }
        if (!bcc_.empty()) {
            m.addEmailHeaderDraft("Bcc", bcc_);
        }
        return ComposeResult::DONE;
    } else {
        CachedComposeResult result = ComposeResult::DONE;
        auto recipientsReader = recipients_;
        std::string toStr;
        std::string ccStr;
        std::string bccStr;
        // Here we are trying to call:
        //    recipients_.load<XX>(recipients_.gen<XX>String());
        // in order to check that parser correctly generates email string and can load it after that
        // unfortunately, because of possible bugs in the parser, it sometimes fails.
        try {
            recipients_.loadTo( to_ );
            toStr = recipients_.genToString();
            recipientsReader.loadTo(toStr);
        } catch(const std::exception&) {
            result.updateIfNotAlreadyAnError(ComposeResult::TO_INVALID);
        }
        try {
            recipients_.loadCc( cc_ );
            ccStr = recipients_.genCcString();
            recipientsReader.loadCc(ccStr);
        } catch(const std::exception&) {
            result.updateIfNotAlreadyAnError(ComposeResult::CC_INVALID);
        }
        try {
            recipients_.loadBcc( bcc_ );
            bccStr = recipients_.genBccString();
            recipientsReader.loadBcc(bccStr);
        } catch(const std::exception&) {
            result.updateIfNotAlreadyAnError(ComposeResult::BCC_INVALID);
        }

        if (recipients_.hasToRecipients()) {
            m.addEmailHeader("To", toStr);
        }
        if (recipients_.hasCcRecipients()) {
            m.addEmailHeader("Cc", ccStr);
        }

        if (recipients_.hasBccRecipients()) {
            m.addEmailHeader("Bcc", bccStr);
        }

        if (!recipients_.hasRecipients()) {
            result.updateIfNotAlreadyAnError(ComposeResult::TO_CC_BCC_EMPTY);
        } else if (recipients_.isLimitExeeded()) {
            result.updateIfNotAlreadyAnError(ComposeResult::MAX_EMAIL_ADDR_REACHED);
        }
        return result;
    }
}

}
