#include <mail/sendbernar/composer/include/rfc_message.h>

namespace sendbernar {

std::string toString(ContentTypeEncoding cte) {
    switch (cte) {
        case ContentTypeEncoding::SevenBit:
            return "7bit";
        case ContentTypeEncoding::EightBit:
            return "8bit";
        case ContentTypeEncoding::Base64:
            return "base64";
    }
}

void RfcMessage::addUtf8Header(const std::string& name, const std::string& value) {
    msg.add_header(name, value, "utf-8");
}

void RfcMessage::addHeader(const std::string& name, const std::string& value) {
    msg.add_header(name, value, "");
}

void RfcMessage::addEmailHeader(const std::string& name, const std::string& value) {
    msg.add_email_header(name, value, "utf-8");
}

void RfcMessage::addEmailHeaderDraft(const std::string& name, const std::string& value) {
    msg.add_email_header_draft(name, value, "UTF-8");
}

void RfcMessage::setUtf8() {
    msg.set_charset("utf-8");
}

void RfcMessage::addMessageId(const std::string& id) {
    msg.add_message_id(id);
}

void RfcMessage::addBody(const std::string& text, ContentTypeEncoding cte, bool isTextHtml) {
    msg.add_ctype("text", isTextHtml ? "html" : "plain", "");
    msg.add_body(text, toString(cte));
}

struct MultipartRelaxedMessageImpl: public MultipartRelaxedMessage {
    message& msg;

    MultipartRelaxedMessageImpl(message& m)
        : msg(m)
    { }

    MimeParser::Hid addRemoteAttach(MimeType mType, const RemoteAttachment& att) override {
        return msg.add_part(mType.type(), mType.subtype(), "", att.body, att.encoding, att.name, att.disposition,
                            "<" + att.cid + ">", att.remote_path, true, "");
    }
};

MimeParser::Hid RfcMessage::addPart(RfcMessagePtr part) {
    msg.add_ctype("multipart", "mixed", "");
    std::unique_ptr<message> mm = std::make_unique<message>(std::move(part->msg));
    return msg.add_part(mm.release());
}

MultipartRelaxedMessagePtr RfcMessage::addRelatedPart(RfcMessagePtr part) {
    msg.add_ctype("multipart", "related", "");
    std::unique_ptr<message> mm = std::make_unique<message>(std::move(part->msg));
    msg.add_part(mm.release());
    return std::make_shared<MultipartRelaxedMessageImpl>(msg);
}

MimeParser::Hid RfcMessage::addHid(MimeType mType, const MetaPart& part,
                                   const std::string& text, const std::string& name) {
    msg.add_ctype("multipart", "mixed", "");
    return msg.add_part(mType.type(), mType.subtype(), part.charset(), text, part.encoding(), name, part.contentDisposition(),
                        "", "", false, "UTF-8");
}

void RfcMessage::addNarodAttach(const std::string& text, ContentTypeEncoding cte) {
    msg.add_ctype("multipart", "mixed", "");
    msg.add_part("text", "html", "UTF-8", text, toString(cte),
                 "narod_attachment_links.html", "inline", "", "", true, "us-ascii");
}

MimeParser::Hid RfcMessage::addBase64File(MimeType mType, const std::string& body, const std::string& filename) {
    msg.add_ctype("multipart", "mixed", "");
    return msg.add_part(mType.type(), mType.subtype(), "", body, "base64", filename, "attachment", "", "", true, "UTF-8");
}

MimeParser::Hid RfcMessage::addRfc822Part(const std::string& text) {
    msg.add_ctype("multipart", "mixed", "");
    return msg.add_part("message", "rfc822", "", text, "8bit", "", "", "", "", true, "");
}

std::string RfcMessage::text() {
    return msg.text();
}

}
