#include <mail/sendbernar/composer/include/sanitizer.h>

namespace sendbernar {

namespace {
struct Response {
    std::string body;
    std::string contentType;
};
}

class SanitizerImpl: public Sanitizer {
    std::string uid;
    std::string requestId;
    http_getter::TypedClientPtr httpPtr;
    SanitizerConfiguration config;

public:
    SanitizerImpl(const std::string& uid, const std::string& requestId,
                  const SanitizerConfiguration& config, http_getter::TypedClientPtr httpPtr)
        : uid(uid)
        , requestId(requestId)
        , httpPtr(httpPtr)
        , config(config)
    { }

    std::optional<mail_getter::SanitizerParsedResponse> sanitize(std::string body, const std::string& messageId) override {
        HttpArguments args;
        args.add("s", "mail_unproxy");
        args.add("uid", uid);
        args.add("message_id", messageId);
        args.add("id", requestId);

        std::optional<Response> resp;

        httpPtr->req(httpPtr->toPOST(config.endpoint).getArgs("args"_arg=args).body(std::move(body)))
               ->call(EndpointType::sanitizer, withDefaultHttpWrap([&](yhttp::response r) {
            std::string content;
            if (const auto it = r.headers.find("content-type"); it != r.headers.end()) {
                content = it->second;
            }

            resp = Response{std::move(r.body), std::move(content)};
        }));

        if (resp) {
            return mail_getter::processSanitizerResponse(resp->body, resp->contentType);
        } else {
            return std::nullopt;
        }
    }
};

SanitizerPtr makeSanitizer(const std::string& uid, const std::string& requestId,
                           const SanitizerConfiguration& config, http_getter::TypedClientPtr http) {
    return std::make_shared<SanitizerImpl>(uid, requestId, config, http);
}

}
