#include <mail/sendbernar/composer/include/settings.h>
#include <mail/sendbernar/core/include/logger.h>
#include <yamail/data/serialization/json_writer.h>

BOOST_FUSION_ADAPT_STRUCT(sendbernar::Settings::Values,
    (std::string, defaultEmail)
    (std::string, fromName)
)

namespace sendbernar {

Settings::Values userSettings(const sendbernar::Account& account, MetadataPtr metadata, ContextLogger logger) {
    Settings::Values settings;

    yamail::expected<macs::settings::ProfilePtr> profile = metadata->getSettingsProfile({
        "from_name", "default_email"
    });

    if (!profile) {
        LOGDOG_(logger, warning, log::error_code=profile.error(),
                log::message="couldn't get settings from db. Fill settings from blackbox account");
        settings.fromName = account.fromName;
        settings.defaultEmail = account.defaultAddress;
    } else {
        if (auto fromNameIt = profile.value()->single_settings.find("from_name");
                profile.value()->single_settings.end() != fromNameIt) {
            settings.fromName = fromNameIt->second;
        } else {
            settings.fromName = account.fromName;
        }

        if (auto defaultEmailIt = profile.value()->single_settings.find("default_email");
                profile.value()->single_settings.end() != defaultEmailIt &&
                account.validateAddress(defaultEmailIt->second)) {
            settings.defaultEmail = defaultEmailIt->second;
        } else {
            settings.defaultEmail = account.defaultAddress;
        }
    }

    LOGDOG_(logger, notice, log::settings=yamail::data::serialization::toJson(settings));

    return settings;
}

}
