#include <mail/sendbernar/composer/include/smiles.h>

namespace sendbernar {

int Smiles::getAttachment(const std::string& classId, RemoteAttachment& att, InlineHandlerAttributes& attr) {
    auto e = endpoint_.format(fmt::arg("smile_id", classId));

    att.convertToJpeg();
    att.cid = "smile" + classId;
    att.remote_path = e.method();


    std::optional<std::string> result;
    attr.http.req(attr.http.toGET(e))->call(EndpointType::smiles, withDefaultHttpWrap([&](yhttp::response resp) {
        result = std::make_optional(std::move(resp.body));
    }));

    if (result) {
        att.body = *result;
        att.remote_path = host_ + e.method();
        return true;
    } else {
        return false;
    }
}

}
