#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/core/include/compose_config.h>


namespace sendbernar {

ComposeConfig::ComposeConfig(const SendConfiguration &cfg)
    : reminders(cfg.reminders())
    , vdirect(cfg.vdirect())
    , smtplimits(cfg.smtplimits())
    , sanitizer(cfg.sanitizer())
    , mailStorage(cfg.mailStorage())
    , smiles(cfg.smiles())
    , diskAttachesTitles(cfg.diskAttachesTitles())
    , attachmentsMaxSize(cfg.attachmentsMaxSize())
    , messageMaxSize(cfg.messageMaxSize())
    , maxRecipients(cfg.maxRecipients())
    , contentTypeDetector(cfg.contentTypeDetector())
    , mobileCallers(cfg.mobileCallers())
    , keyContainer(cfg.keyContainer())
    , disk(cfg.disk())
    , domainsNotToLowercase(cfg.domainsNotToLowercase())
    , recognizer(cfg.recognizer())
{}

ComposeConfig::ComposeConfig(const Recognizer::Wrapper& recognizer)
    : recognizer(recognizer)
{}

}
