#include <mail/sendbernar/core/include/config.h>
#include <mail/sendbernar/core/include/sharpei.h>
#include <butil/http/extract_auth_domain.h>
#include <yplatform/reactor.h>

namespace sendbernar {

std::string authDomain(const params::CommonParams& params) {
    const std::string domain = http::extractAuthDomain(params.originalHost, ".yandex.ru");

    if (!domain.empty() && domain[0] == '.') {
        return domain.substr(1);
    } else {
        return domain;
    }
}

ConfigPtr makeConfig(const yplatform::ptree& cfg,
                     ymod_cachedb::CachePtr cachedb,
                     http_getter::TypedModulePtr http,
                     ymod_maildb::ModulePtr maildb) {
    auto config = std::make_shared<Config>();

    auto logger = getModuleLogger();

    config->send = std::make_shared<SendConfiguration>(http, cfg.get_child("send"), logger);
    config->attachConfig = std::make_shared<AttachmentConfiguration>(cfg.get_child("send"));

    const auto extractName = [] (auto&& val) {
        return val.second.template get<std::string>("name");
    };

    boost::transform(cfg.equal_range("params_to_hide"),
                     std::inserter(config->paramsToHide, config->paramsToHide.end()), extractName);
    boost::transform(cfg.equal_range("log_response_in_handlers"),
                     std::inserter(config->logResponseInHandlers, config->logResponseInHandlers.end()), extractName);

    config->coroutineStackSize = cfg.get<unsigned>("coroutine_stack_size");

    config->maildb = maildb;
    config->cachedb = cachedb;
    config->http = http;

    return config;
}

}
