#include <mail/sendbernar/core/include/disk_attach_builder.h>
#include <butil/butil.h>

#include <boost/algorithm/string/join.hpp>
#include <boost/range/adaptor/transformed.hpp>
#include <boost/format.hpp>

namespace sendbernar {

std::string DiskAttachBuilder::build(const std::vector<params::DiskAttach>& attaches) const {
    const auto htmls = attaches | boost::adaptors::transformed([&](auto& a){
        return this->makeAttach(a);
    });
    return boost::algorithm::join(htmls, "");
}

std::string DiskAttachBuilder::makeAttach(const params::DiskAttach& attach) const {
    return boost::str( boost::format(htmlTemplate) % diskUrl(attach) % preview(attach) % diskHash(attach) % fullName(attach) );
}

std::string DiskAttachBuilder::diskUrl(const params::DiskAttach& attach) const {
    return conf_.host + attach.path;
}

std::string DiskAttachBuilder::diskHash(const params::DiskAttach& attach) const {
    return !attach.hash ? "" : boost::str( boost::format(hashTemplate) % *attach.hash);
}

std::string DiskAttachBuilder::preview(const params::DiskAttach& attach) const {
    if (!attach.preview_path)
        return "";
    return boost::str( boost::format(previewTemplate) % encode_url(conf_.previewHost + *attach.preview_path) );
}

std::string DiskAttachBuilder::fullName(const params::DiskAttach& attach) const {
    if (attach.size) {
        return boost::str( boost::format(nameTemplate) % attach.name % *attach.size );
    } else if (attach.folder) {
        return boost::str( boost::format(nameTemplate) % attach.name % *attach.folder);
    }
    return attach.name;
}

const std::string DiskAttachBuilder::hashTemplate = R"r( data-hash="%1%")r";
const std::string DiskAttachBuilder::previewTemplate = R"r( data-preview="%1%")r";
const std::string DiskAttachBuilder::nameTemplate = R"r(%1% (%2%))r";
const std::string DiskAttachBuilder::htmlTemplate = R"r(<a class="narod-attachment" target="_blank")r"
                                                    R"r( rel="noopener noreferrer" href="%1%"%2%%3%>%4%</a><br>)r";
}
