#include <mail/sendbernar/core/include/disk_attaches_title_templates.h>
#include <mail/sendbernar/client/include/error_result.h>
#include <mail/sendbernar/client/include/category.h>
#include <yamail/data/deserialization/json_reader.h>
#include <fstream>
#include <format>

namespace sendbernar {

DiskAttachesTitleTemplates::DiskAttachesTitleTemplates(const std::string& json_path) {
    std::ifstream in(json_path);
    if (!in.is_open()) {
        throw mail_errors::system_error(make_error(ErrorResult::unexpectedCondition, 
            std::format("cant find file with disk title translates. Path: '{}'", json_path)
        ));
    }
    std::string json = {std::istreambuf_iterator<char>(in), std::istreambuf_iterator<char>()};
    templates_ = yamail::data::deserialization::fromJson<decltype(templates_)>(json);
}

const std::string& DiskAttachesTitleTemplates::find(const std::string& user_lang) {
    const std::string fallback = "en";
    for(const auto& lang : {user_lang, fallback}) {
        if (templates_.count(lang)) {
            return templates_[lang];
        }
    }
    throw mail_errors::system_error(make_error(ErrorResult::unexpectedCondition, 
        std::format("unexpected language '{}' and cant find fallback language '{}'", user_lang, fallback)
    ));
}

}
