#include <mail/sendbernar/core/include/http.h>

namespace sendbernar {

struct LogRequestStats: public http_getter::RequestStats {
    RequestMertics logStats_;
    http_getter::RequestStatsPtr withLogger_;
    metrics::ServiceRequest request_;

    LogRequestStats(http_getter::RequestStatsPtr withLogger, RequestMertics logStats)
        : logStats_(std::move(logStats))
        , withLogger_(std::move(withLogger))
    { }

    virtual ~LogRequestStats() { }

    void starting(const std::string& operation) override {
        withLogger_->starting(operation);
        request_.operation = operation;
    }

    void responseIsGot(const std::string& operation, unsigned try_n, double elapsed,
                       const std::string& body, unsigned httpCode, http_getter::Result r) override {
        withLogger_->responseIsGot(operation, try_n, elapsed, body, httpCode, r);
        request_.calls.emplace_back(metrics::ServiceRequest::HttpCall(httpCode, elapsed));
    }

    void responseIsGot(const std::string& operation, unsigned try_n, double elapsed,
                       const std::optional<std::string>& body, const std::exception& ex) override {
        withLogger_->responseIsGot(operation, try_n, elapsed, body, ex);
        request_.calls.emplace_back(metrics::ServiceRequest::HttpCall(elapsed));
    }

    void responseIsGot(const std::string& operation, unsigned try_n, double elapsed,
                       const std::optional<std::string>& body, const boost::system::error_code& ec) override {
        withLogger_->responseIsGot(operation, try_n, elapsed, body, ec);
        request_.calls.emplace_back(metrics::ServiceRequest::HttpCall(elapsed));
    }

    void finishing(const std::string& operation, http_getter::Result r) override {
        switch(r) {
            case http_getter::Result::success: request_.status = http_getter::RequestStatus::success;   break;
            case http_getter::Result::fail:    request_.status = http_getter::RequestStatus::fail;      break;
            case http_getter::Result::retry:   request_.status = http_getter::RequestStatus::try_limit; break;
        }
        withLogger_->finishing(operation, r);
        logStats_.serviceRequest(request_);
        request_ = metrics::ServiceRequest();
    }
};

http_getter::RequestStatsPtr withLogAndUnistat(http_getter::Logger logger,
                                        const RequestMertics& metrics) {
    return std::make_shared<LogRequestStats>(http_getter::withLog(std::move(logger)), metrics);
}

}
