#pragma once

#include <string>
#include <vector>
#include <butil/email/helpers.h>
#include <mail/sendbernar/client/include/params.h>


namespace sendbernar {

struct Account {
    std::string uid;
    std::string language;
    std::string login;
    std::string domain;
    std::string country;
    std::string karmaStatus;
    std::string karmaValue;
    std::string timezone;
    std::vector<std::string> addresses;
    std::vector<std::string> validated;
    std::string defaultAddress;
    std::string fromName;

    bool validateAddress(const std::string& address) const {
        auto it = std::find_if(addresses.begin(), addresses.end(), EmailHelpers::YandexEmailEqPred(address));

        if (it != addresses.end()) {
            return true;
        }

        return std::find_if(validated.begin(), validated.end(), EmailHelpers::EmailEqPred(address)) != validated.end();
    }

    bool hasAddress(const std::string& address) const {
        return std::find_if(addresses.begin(), addresses.end(), EmailHelpers::YandexEmailEqPred(address)) != addresses.end();
    }
};

}
