#pragma once

#include <string>
#include <yplatform/ptree.h>

namespace sendbernar {

struct AttachmentConfiguration {

    AttachmentConfiguration(const yplatform::ptree& cfg)
            : shieldTimeout(std::chrono::seconds(cfg.get<unsigned>("attach_shield_timeout_sec"))),
              expireTimeout(std::chrono::hours(cfg.get<unsigned>("attach_ttl_hours"))) {
    }

    std::chrono::seconds shieldTimeout;
    std::chrono::hours expireTimeout;
};

}
