#pragma once

#include <mail/sendbernar/client/include/result.h>
#include <mail/sendbernar/client/include/compose_result.h>
#include <mail/sendbernar/client/include/category.h>

namespace sendbernar {

struct CachedComposeResult {
    ComposeResult value_;

    CachedComposeResult(ComposeResult result = ComposeResult::EMPTY)
        : value_(result)
    { }

    void updateIfNotAlreadyAnError(ComposeResult result) {
        if (succeeded()) {
            value_ = result;
        }
    }

    bool succeeded() const {
        return value_ == ComposeResult::EMPTY || value_ == ComposeResult::DONE;
    }

    bool atLeastComposed() const {
        return value_ != ComposeResult::ATTACHMENT_TOO_BIG &&
               value_ != ComposeResult::ATTACHMENT_STORAGE_ERROR &&
               value_ != ComposeResult::PARTS_JSON_INVALID &&
               value_ != ComposeResult::SANITIZER_CALL_WAS_NOT_SUCCESS &&
               value_ != ComposeResult::MSG_TOO_BIG;
    }

    bool operator !=(ComposeResult result) {
        return value_ != result;
    }
};

inline bool operator == (CachedComposeResult cached, ComposeResult result) {
    return cached.value_ == result;
}

inline mail_errors::error_code make_error(CachedComposeResult result) {
    return make_error(result.value_);
}

}
