#pragma once

#include <mail_getter/vdirect/keys_storage.h>
#include <mail/callmeback/client/config_reflection.h>
#include <mail/sendbernar/core/include/remind_templates.h>

namespace sendbernar {

using SmtpLimits = std::map<std::string, unsigned long long>;

struct RemindersConfiguration {
    callmeback::ClientConfig clientConfiguration;
    unsigned sendUndoAdditionalTime = 0;
    unsigned noAnswerRemindPeriod = 0;
    RemindTemplates noAnswerTemplates;
    RemindTemplates barbetCreateFailedTemplates;
    RemindTemplates barbetRestoreFailedTemplates;
};

struct Settings {
    struct Values {
        std::string defaultEmail;
        std::string fromName;
    } defaults;
};

struct Vdirect {
    std::string uidScript;
    vdirect::KeysStorage keysStorage;
};

struct SanitizerConfiguration {
    http_getter::TypedEndpoint endpoint;
    size_t maxRequestSize = 0;
};

struct Disk {
    std::string host;
    std::string previewHost;
};

struct SmilesConfiguration {
    http_getter::TypedEndpoint endpoint;
    std::string host;
};

}
