#pragma once

#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/core/include/common_configuration.h>

namespace sendbernar {
struct ComposeConfig {
    ComposeConfig(const SendConfiguration& cfg);
    ComposeConfig(const Recognizer::Wrapper& recognizer);

    RemindersConfiguration reminders;

    Vdirect vdirect;
    SmtpLimits smtplimits;
    SanitizerConfiguration sanitizer;
    mail_getter::ServiceFactoryPtr mailStorage;
    SmilesConfiguration smiles;

    DiskAttachesTitleTemplates diskAttachesTitles;
    size_t attachmentsMaxSize = 0;
    size_t messageMaxSize = 0;
    unsigned maxRecipients = 0;

    std::shared_ptr<ContentTypeDetector> contentTypeDetector;
    std::vector<std::string> mobileCallers;
    mail_getter::attach_sid::KeyContainer keyContainer;

    Disk disk;

    std::set<std::string> domainsNotToLowercase;

    const Recognizer::Wrapper& recognizer;
};

using ComposeConfigPtr = std::shared_ptr<ComposeConfig>;
}
