#pragma once


#include <vector>
#include <ctime>

#include <mail/sendbernar/core/include/recipients_repository.h>
#include <mail/sendbernar/core/include/cached_compose_result.h>
#include <macs/types.h>
#include <yamail/expected.h>

namespace sendbernar::compose {

struct Attachment {
    std::string hid_;
    std::string oldHid_;
    std::string contentType_;
    std::string fileName_;
    std::string id_;
    std::size_t size_ = 0;
    std::string hash_;
};

struct Error {
    CachedComposeResult result;
    std::string messageId;
};

template<class T>
using Expected = yamail::expected<T, Error>;

struct ComposeDraft {
    std::vector<Attachment> attachments;
    std::string envelopeFrom;
    boost::shared_ptr<std::string> text;
};

struct ComposeMessage {
    std::string envelopeFrom;
    boost::shared_ptr<std::string> text;
    RecipientsRepository recipients;
};

struct SaveDraftOrTemplate {
    std::string messageId;
    std::vector<Attachment> attachments;
    std::string realMailbox;
    boost::shared_ptr<std::string> text;
};

struct SendDelayed {
    RecipientsRepository recipients;
    LimitedResult limited_;
    std::time_t sendDate = 0;
    std::string realMailbox;
    boost::shared_ptr<std::string> text;
    std::string nonEmptySubject;
    std::string messageId;
    std::time_t date = 0;
    std::vector<macs::Mid> forwardedMids;
    std::vector<Attachment> attachments;
};

struct SendMessage {
    RecipientsRepository recipients;
    LimitedResult limited_;
    std::string messageId;
    bool hasAttachments = false;
    bool saveToSent = false;
    std::string envelopeFrom;
    std::string realMailbox;
    boost::shared_ptr<std::string> text;
    std::vector<Attachment> attachments;
    std::string nonEmptySubject;
    std::time_t date = 0;
    std::vector<macs::Mid> forwardedMids;
};

struct SendShare {
    SendMessage message;
    std::string envelopeFrom;
    std::string adminUid;
};

struct SystemMessage {
    std::string envelopeFrom;
    boost::shared_ptr<std::string> text;
};

}
