#pragma once

#include <yplatform/ptree.h>
#include <mail/sendbernar/core/include/configuration.h>
#include <macs_pg/integration/common_configure.h>
#include <mail/sendbernar/core/include/attach_config.h>
#include <mail/sendbernar/core/include/logger.h>
#include <mail/http_getter/client/include/module.h>
#include <mail/ymod_cachedb/include/cache.h>
#include <mail/ymod_maildb/include/module.h>
#include <set>


namespace sendbernar {

struct Config {
    SendConfigurationPtr send;
    std::shared_ptr<AttachmentConfiguration> attachConfig;
    std::set<std::string> paramsToHide;
    std::set<std::string> logResponseInHandlers;
    unsigned coroutineStackSize = 0;
    ymod_cachedb::CachePtr cachedb;
    http_getter::TypedModulePtr http;
    ymod_maildb::ModulePtr maildb;
};

using ConfigPtr = std::shared_ptr<Config>;

ConfigPtr makeConfig(const yplatform::ptree& cfg, ymod_cachedb::CachePtr cache,
                     http_getter::TypedModulePtr http, ymod_maildb::ModulePtr maildb);
std::string authDomain(const params::CommonParams& params);

}
