#pragma once


#include <mail/sendbernar/core/include/remind_templates.h>
#include <mail/sendbernar/core/include/disk_attaches_title_templates.h>
#include <mail/user_journal/helpers/geobase.h>
#include <mail/user_journal/helpers/uatraits.h>
#include <mail/sendbernar/core/include/http.h>
#include <mail/sendbernar/core/include/user_journal.h>
#include <mail/sendbernar/core/include/common_configuration.h>

#include <macs_pg/service/service.h>
#include <user_journal/service.h>
#include <user_journal/connection_info.h>
#include <mail_getter/alias_class_list.h>
#include <mail_getter/vdirect/interface.h>
#include <mail_getter/content_type.h>
#include <mail_getter/service_factory.h>


namespace sendbernar {

struct SendConfiguration {
    struct Captcha {
        http_getter::TypedEndpoint check;
        http_getter::TypedEndpoint generate;

        std::string type;
        std::string strongType;
    };

    struct Smtp {
        http_getter::TypedEndpoint send;
        http_getter::TypedEndpoint save;
        http_getter::TypedEndpoint save_delayed;
        http_getter::TypedEndpoint system_send;
        http_getter::TypedEndpoint delayed_callback_send;
    };

    using NwSmtp = Smtp;

    using BlackBox = http_getter::TypedEndpoint;
    using Sharpei = http_getter::TypedEndpoint;

    SendConfiguration(const http_getter::TypedModulePtr& httpGetter, const yplatform::ptree& cfg, ModuleLogger& logger);

#define DECLARE(type, name) \
    private: type name##_;
#define DECLARE_AND_GETTER(type, name) \
    DECLARE(type, name) \
    public: type  name() const { return name##_; }
#define DECLARE_AND_GETTER_CREF(type, name) \
    DECLARE(type, name) \
    public: const type& name() const { return name##_; }

    DECLARE_AND_GETTER_CREF(RemindersConfiguration, reminders)
    DECLARE_AND_GETTER_CREF(DiskAttachesTitleTemplates, diskAttachesTitles)
    DECLARE_AND_GETTER_CREF(SendConfiguration::Captcha, captcha)
    DECLARE_AND_GETTER_CREF(Vdirect, vdirect)
    DECLARE_AND_GETTER_CREF(std::string, wmiYplatformServer)
    DECLARE_AND_GETTER_CREF(std::string, wmiServer)
    DECLARE_AND_GETTER_CREF(AliasClassList, mimeTypesList)
    DECLARE_AND_GETTER_CREF(SmtpLimits, smtplimits)
    DECLARE_AND_GETTER_CREF(SanitizerConfiguration, sanitizer)
    DECLARE_AND_GETTER_CREF(SendConfiguration::Sharpei, sharpei)
    DECLARE_AND_GETTER_CREF(mail_getter::ServiceFactoryPtr, mailStorage)
    DECLARE_AND_GETTER_CREF(SmilesConfiguration, smiles)

    DECLARE_AND_GETTER(size_t, attachmentsMaxSize)
    DECLARE_AND_GETTER(size_t, messageMaxSize)
    DECLARE_AND_GETTER(unsigned, maxRecipients)
    DECLARE_AND_GETTER(double, limitsFactor)

    DECLARE_AND_GETTER_CREF(SendConfiguration::BlackBox, blackBox)
    DECLARE_AND_GETTER(std::shared_ptr<ContentTypeDetector>, contentTypeDetector)
    DECLARE_AND_GETTER_CREF(SendConfiguration::NwSmtp, nwsmtp)
    DECLARE_AND_GETTER(std::vector<std::string>, mobileCallers)
    DECLARE_AND_GETTER_CREF(mail_getter::attach_sid::KeyContainer, keyContainer)
    DECLARE_AND_GETTER_CREF(mail_getter::attach_sid::Keys, keys)

    DECLARE_AND_GETTER_CREF(Disk, disk)
    
    DECLARE_AND_GETTER_CREF(std::set<std::string>, domainsNotToLowercase)

#undef DECLARE_AND_GETTER_CREF
#undef DECLARE_AND_GETTER
#undef DECLARE

    const Recognizer::Wrapper& recognizer() const {
        return *recognizer_;
    }

private:
    Recognizer::WrapperPtr recognizer_;
};

std::time_t delayedMessageSendDate(const params::SendDelayed& params, unsigned additionalTime,
                                   std::function<std::time_t(void)> now = []() { return time(nullptr); });

using SendConfigurationPtr = std::shared_ptr<SendConfiguration>;

}
