#pragma once

#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/client/include/params.h>

namespace sendbernar {

using DiskConfig = Disk;

class DiskAttachBuilder {
public:
    DiskAttachBuilder(DiskConfig conf) : conf_(std::move(conf)) { }
    std::string build(const std::vector<params::DiskAttach>&) const;

private:
    DiskConfig conf_;

    std::string makeAttach(const params::DiskAttach&) const;
    std::string diskUrl(const params::DiskAttach&) const;
    std::string diskHash(const params::DiskAttach&) const;
    std::string preview(const params::DiskAttach&) const;
    std::string fullName(const params::DiskAttach&) const;

    static const std::string hashTemplate;
    static const std::string previewTemplate;
    static const std::string nameTemplate;
    static const std::string htmlTemplate;
};

}
