#pragma once

#include <memory>

#include <yplatform/log.h>
#include <macs/types.h>
#include <macs_pg/logging.h>
#include <mail_getter/logging.h>
#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#include <yamail/data/reflection/details/adt.h>
#include <mail/sendbernar/metrics/metrics.h>

namespace sendbernar {

namespace log {

LOGDOG_DEFINE_ATTRIBUTE(int, code)
LOGDOG_DEFINE_ATTRIBUTE(macs::Mid, mid)
LOGDOG_DEFINE_ATTRIBUTE(std::string, karma_value)
LOGDOG_DEFINE_ATTRIBUTE(unsigned, inline_attaches)
LOGDOG_DEFINE_ATTRIBUTE(bool, has_narod_attaches)
LOGDOG_DEFINE_ATTRIBUTE(unsigned, attached_message_size)
LOGDOG_DEFINE_ATTRIBUTE(unsigned, attach_size)
LOGDOG_DEFINE_ATTRIBUTE(unsigned, write_attachment_size)
LOGDOG_DEFINE_ATTRIBUTE(unsigned, body_size)
LOGDOG_DEFINE_ATTRIBUTE(macs::Fid, fid)
LOGDOG_DEFINE_ATTRIBUTE(macs::Lids, lids)
LOGDOG_DEFINE_ATTRIBUTE(std::string, settings)


using namespace ::logdog::attr;

constexpr static auto sendbernar_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-sendbernar-tskv-log"));

} // namespace log

inline auto getYplatformBackend(const std::string& loggerName) {
    return std::make_shared<yplatform::log::source>(yplatform::log::find(loggerName, true));
}

inline auto getModuleLogger() {
    auto logger = getYplatformBackend("sendbernar");
    return ::logdog::make_log(log::sendbernar_formatter, logger);
}

using ModuleLogger = decltype(getModuleLogger());

inline auto getContextLogger(const std::string& requestId, boost::optional<std::string> uid) {
    auto uid_param = uid ? log::uid=uid.get() : log::uid=::logdog::none;
    return ::logdog::bind(getModuleLogger(), uid_param, log::x_request_id=requestId);
}

using ContextLogger = decltype(getContextLogger("", boost::none));

inline auto getMetricsLogger(const std::string& version, const std::string& requestId, boost::optional<std::string> uid) {
    auto logger = ::logdog::make_log(log::sendbernar_formatter, getYplatformBackend("metrics"));
    auto uid_param = uid ? log::uid=uid.get() : log::uid=::logdog::none;

    return ::logdog::bind(logger, uid_param, log::x_request_id=requestId, metrics::log::version=version);
}

using MetricsLogger = decltype(getMetricsLogger("", "", boost::none));

macs::pg::logging::v2::LogPtr getMacsPgLogger(ContextLogger l);

mail_getter::logging::LogPtr getMulcagateLogger(ContextLogger l);

} // namespace sendbernar
