#pragma once

#include <macs/envelopes_repository.h>
#include <macs/labels_repository.h>
#include <mail_getter/MessageAccessParams.h>
#include <mail/sendbernar/core/include/account.h>
#include <mail/sendbernar/core/include/logger.h>
#include <mail/sendbernar/client/include/params.h>
#include <mail/sendbernar/core/include/http.h>
#include <mail/ymod_maildb/include/params.h>
#include <boost/asio/spawn.hpp>
#include <yamail/expected.h>

namespace sendbernar {

struct Config;

struct Metadata {
    virtual ~Metadata() { }

    virtual macs::Envelope getById(const macs::Mid& mid) const = 0;
    virtual yamail::expected<macs::settings::ProfilePtr> getSettingsProfile(macs::settings::SettingsList settingsList) const = 0;
    virtual std::vector<macs::Envelope> getEnvelopesWithNoAnswer(const std::string& messageId, const macs::Lid& lid) const = 0;
    virtual macs::MidVec getByMessageId(const std::string& messageId, const macs::FidVec& excludedFids) const = 0;
    virtual std::string getMessageId(const macs::Mid& mid) const = 0;
    virtual macs::Fid fidBySymbol(const macs::Folder::Symbol& symbol) const = 0;
    virtual std::pair<macs::error_code, macs::MidsWithMimes> getMimes(const macs::MidVec& mids) const = 0;
    virtual mail_getter::MessageAccessWithWindatParams getMessageAccessWithWindatParams(const macs::Mid& mid) const = 0;
    virtual mail_getter::MessageAccessParams getMessageAccessParams(const macs::Mid& mid) const = 0;

    virtual void unmarkEnvelopes(const macs::Mid& mid, const macs::Labels& labels) const = 0;
    virtual void markEnvelopes(const macs::MidVec& mids, const macs::Labels& labels) const = 0;
    virtual void deleteDraft(const macs::Mid& mid) const = 0;
    virtual void moveMessage(const macs::Fid& fid, const macs::Mid& mids) const = 0;
    virtual macs::Label labelBySymbol(const macs::Label::Symbol& symbol) const = 0;

    virtual std::shared_ptr<Metadata> clone(boost::asio::yield_context yield) const = 0;
};

using MetadataPtr = std::shared_ptr<Metadata>;

MetadataPtr getMetadata(const params::CommonParams& params, const params::UserJournalParams& uj,
                        ContextLogger logger, std::shared_ptr<Config> config);

ymod_maildb::ServiceParams serviceParams(params::CommonParams params);

}
