#pragma once

#include <mail/sendbernar/metrics/metrics.h>
#include <mail/sendbernar/core/include/logger.h>
#include <mail/sendbernar/client/include/category.h>
#include <mail/sendbernar/client/include/request.h>

namespace sendbernar {

struct RequestMertics {
    MetricsLogger logger;

    RequestMertics(MetricsLogger logger)
        : logger(std::move(logger))
    { }

    void serviceRequest(const metrics::ServiceRequest& call) const {
        LOGDOG_(logger, notice, metrics::serialize(call));
    }

    void smtpGateStatus(DeliveryResult result) const {
        LOGDOG_(logger, notice, metrics::serialize(metrics::SmtpGate{result}));
    }

    static bool properErrorCategory(const boost::system::error_category& c) {
        return c == getSendbernarCategory()
            || c == getNwCategory()
            || c == getComposeCategory();
    }

    void mailSendAndSendbernarErrorCode(mail_errors::error_code ec) const {
        const auto& c = ec.category();
        if (properErrorCategory(c)) {
            const metrics::ErrorCode m{c.name(), ec.value(), c.message(ec.value())};
            LOGDOG_(logger, notice, metrics::serialize(m));
        }
    }
};

inline RequestMertics getRequestMetrics(const Request& req, const std::string& path) {
    const std::string sc = req.optionalArg("sc").get_value_or("");
    const std::string v = req.optionalArg("v").get_value_or("");
    const std::string caller = req.optionalArg("caller").get_value_or("");

    auto logger = getMetricsLogger(metrics::version(caller, v, sc, path)
                                   , req.optionalHeader("X-Request-Id").get_value_or("")
                                   , req.optionalArg("uid"));

    return RequestMertics(std::move(logger));
}

}
