#pragma once

#include <map>
#include <stdexcept>
#include <string>

namespace sendbernar {

class RemindTemplatesError : public std::runtime_error {
public:
    RemindTemplatesError(const std::string& what) : std::runtime_error(what) {}
};

struct RemindTemplate {
    std::string fromName;
    std::string fromMailbox;
    std::string subject;
    std::string body;
};

typedef std::map<std::string, RemindTemplate> RemindTemplates;

RemindTemplates createRemindTemplates(const std::string &path);

}
