#include <mail/sendbernar/core/include/logger.h>

#include <logdog/logger.h>
#include <logdog/backend/yplatform_log.h>

namespace sendbernar {

using MacsPgLog = macs::pg::logging::v2::TypedLog<ContextLogger>;

struct MulcagateLog: public mail_getter::logging::Log {
    using Logger = ContextLogger;

    Logger logger;

    using ServiceName = mail_getter::logging::ServiceName;
    using Message = mail_getter::logging::Message;

    MulcagateLog(Logger l)
        : logger(std::move(l))
    { }

    void warning(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, warning, log::where_name=name, log::message=msg);
    }

    void error(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, error, log::where_name=name, log::message=msg);
    }

    void notice(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, notice, log::where_name=name, log::message=msg);
    }

    void debug(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, debug, log::where_name=name, log::message=msg);
    }
};

macs::pg::logging::v2::LogPtr getMacsPgLogger(ContextLogger l) {
    return std::make_shared<MacsPgLog>(std::move(l));
}

mail_getter::logging::LogPtr getMulcagateLogger(ContextLogger l) {
    return std::make_shared<MulcagateLog>(std::move(l));
}

}
