#include <map>
#include <algorithm>
#include <boost/bind.hpp>
#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/json_parser.hpp>
#include <mail/sendbernar/core/include/remind_templates.h>

namespace sendbernar {

typedef boost::property_tree::ptree Tree;
typedef Tree::const_iterator::reference Node;

RemindTemplates::value_type transformTree(Node templateNode) {
    RemindTemplate remindTemplate;
    remindTemplate.fromName = templateNode.second.get<std::string>("name");
    remindTemplate.fromMailbox = templateNode.second.get<std::string>("email");
    remindTemplate.subject = templateNode.second.get<std::string>("subject");
    remindTemplate.body = templateNode.second.get<std::string>("body");

    return RemindTemplates::value_type(templateNode.first , remindTemplate);
}

RemindTemplates createRemindTemplates (const std::string & path) {
    try {
        RemindTemplates out;
        if (!path.empty()) {
            Tree jsonData;
            boost::property_tree::read_json(path, jsonData);
            const Tree& jsonTemplates = jsonData.get_child("templates");
            std::transform(jsonTemplates.begin(), jsonTemplates.end(),
                    std::inserter(out, out.end()), transformTree );
        }
        return out;
    } catch (const std::exception & e) {
        throw RemindTemplatesError(
                std::string("error loading reminder templates: ") + e.what());
    }
}

}
