#include <mail/sendbernar/core/include/sharpei.h>
#include <mail/http_getter/client/include/client.h>
#include <yamail/data/deserialization/json_reader.h>

BOOST_FUSION_DEFINE_STRUCT((sendbernar), Database,
    (std::string, role)
    (std::string, status)
)

BOOST_FUSION_DEFINE_STRUCT((sendbernar), Sharpei,
    (std::vector<sendbernar::Database>, databases)
)

namespace sendbernar {

const std::string sharpeiAliveDbStatus = "alive";

bool isMasterAlive(const std::string& uid, const http_getter::TypedEndpoint& config, const http_getter::TypedClient& http) {
    HttpArguments args;
    args.add("uid", uid);
    args.add("mode", "write_only");

    bool result = false;

    http.req(http.toGET(config).getArgs("args"_arg=args))->call(EndpointType::sharpei, withDefaultHttpWrap([&] (yhttp::response resp) {
        const auto databases = yamail::data::deserialization::fromJson<Sharpei>(resp.body).databases;

        if (databases.size() == 1) {
            result = databases[0].status == sharpeiAliveDbStatus;
        }
    }));

    return result;
}

}
