#include <mail/sendbernar/metrics/metrics.h>

#include <yamail/data/reflection.h>
#include <yamail/data/serialization/json_writer.h>
#include <yamail/data/deserialization/json_reader.h>

#include <mail/sendbernar/client/include/metrics_reflection.h>

namespace sendbernar::metrics {

YREFLECTION_DEFINE_ENUM_INLINE(Type,
    ServiceRequest,
    SmtpGate,
    ErrorCode
)

Serialized serialize(const ServiceRequest& metric) {
    return std::make_tuple(
        log::type=to_string(Type::ServiceRequest),
        log::value=yamail::data::serialization::toJson(metric).str()
    );
}

Serialized serialize(const ErrorCode& metric) {
    return std::make_tuple(
        log::type=to_string(Type::ErrorCode),
        log::value=yamail::data::serialization::toJson(metric).str()
    );
}

Serialized serialize(const SmtpGate& metric) {
    return std::make_tuple(
        log::type=to_string(Type::SmtpGate),
        log::value=yamail::data::serialization::toJson(metric).str()
    );
}

AnyMetric deserialize(const std::map<std::string, std::string>& record) {
    namespace yr = yamail::data::reflection;

    const auto itType = record.find(logdog::name(log::type));

    if (itType == record.end()) {
        return AnyMetric();
    }
    const std::string value = record.at(logdog::name(log::value));

    Type type;
    if (!yr::from_string(itType->second, type)) {
        return AnyMetric();
    }

    switch(type) {
        case Type::ServiceRequest:
            return yamail::data::deserialization::JsonReader<ServiceRequest>(value).result();
        case Type::ErrorCode:
            return yamail::data::deserialization::JsonReader<ErrorCode>(value).result();
        case Type::SmtpGate:
            return yamail::data::deserialization::JsonReader<SmtpGate>(value).result();
    }
}

std::string version(const std::string& caller, const std::string& v,
                    const std::string& sc, const std::string& path) {
    using namespace std::string_literals;
    return caller + "@"s + v + "@"s + sc + "@"s + path;
}

}
