#pragma once

#include <logdog/attribute.h>

#include <mail/sendbernar/client/include/metrics.h>

namespace sendbernar::metrics {

namespace log {
LOGDOG_DEFINE_ATTRIBUTE(std::string_view, type)
LOGDOG_DEFINE_ATTRIBUTE(std::string, value)
LOGDOG_DEFINE_ATTRIBUTE(std::string, version)
}

using AnyMetric = std::variant<std::monostate, ServiceRequest, SmtpGate, ErrorCode>;
using Serialized = decltype(std::make_tuple(log::type=std::string_view(), log::value=std::string()));

Serialized serialize(const ServiceRequest& metric);
Serialized serialize(const ErrorCode& metric);
Serialized serialize(const SmtpGate& metric);

AnyMetric deserialize(const std::map<std::string, std::string>& record);
std::string version(const std::string& caller, const std::string& v,
                    const std::string& sc, const std::string& path);

}
