#!/bin/bash

export app=sendbernar
export dog_name=sendbernar

source /opt/service_sh/environment_type.sh
source /opt/service_sh/attach_sid.sh
source /opt/service_sh/ephemerial.sh
source /opt/service_sh/push_client_to_ephemerial.sh push-client-sendbernar-log
source /opt/service_sh/postgres.sh
source /opt/service_sh/tvm.sh
source /opt/service_sh/tzdata.sh
source /opt/service_sh/recognizer.sh
source /opt/service_sh/ssl.sh
source /opt/service_sh/link_common_files.sh
source /opt/service_sh/link_nginx_config.sh
source /opt/service_sh/link_push_client.sh
source /opt/service_sh/vdirectkeys.sh

ln -sf /etc/nginx/sites-available/service.conf-${ENVIRONMENT} /etc/nginx/sites-enabled/service.conf
ln -sf /etc/nginx/sites-available/service.location-${ENVIRONMENT} /etc/nginx/sites-enabled/service.location
ln -sf /etc/nginx/sites-available/service.include /etc/nginx/sites-enabled/service.include
ln -sf /etc/nginx/sites-available/handler_proxy.include /etc/nginx/sites-enabled/handler_proxy.include
ln -sf /etc/nginx/sites-available/callback_proxy.include /etc/nginx/sites-enabled/callback_proxy.include
ln -sf /etc/nginx/sites-available/log_by_lua.include /etc/nginx/sites-enabled/log_by_lua.include

source /opt/service_sh/nginx_upstream.sh

# need only for wmi-qa or wmi-prestable env
if [[ "${ENVIRONMENT}" == "prestable" ]] || [[ "${ENVIRONMENT}" == "testing" ]]; then
    echo "Running /opt/postinst.sh"
    /opt/postinst.sh
    if [[ "$?" != 0 ]]; then
        echo "Fail in postinst script"
        exit 1
    fi
fi
