#include <mail/sendbernar/server/include/base.h>
#include <mail/sendbernar/client/include/result.h>


namespace sendbernar {
namespace server {

namespace tskv = yplatform::tskv;

Base::Base(ConfigPtr configuration)
    : config_(configuration)
    , logArgsConfig_{
        .paramsToHide=config_->paramsToHide,
        .tskvFormat="mail-sendbernar-post-args-log",
        .argsLogger=yplatform::log::find("post_args", true)
    }
{ }

void Base::process(const ymod_webserver::http::stream_ptr& stream) const {
    http_api::logArgsAsTskv(stream, logArgsConfig_);

    const bool logResponse = config_->logResponseInHandlers.count(stream->request()->url.make_full_path());
    Context ctx(stream, logResponse, *config_->http);
    try {
        if (stream->request()->method != method()) {
            ctx.responseWith(make_error(ErrorResult::wrongHttpMethod, "wrong http method"));
            return;
        }

        execute(ctx);
    } catch (const ReaderException& e) {
        ctx.responseWith(make_error(ErrorResult::invalidParam, e.what()));
    } catch (const std::exception& e) {
        ctx.responseWith(make_error(ErrorResult::unexpectedCondition, e.what()));
    } catch (...) {
        ctx.responseWith(make_error(ErrorResult::unexpectedCondition, "unexpected condition"));
    }
}

}
}
