#include <mail/sendbernar/server/include/callbacks/no_answer_remind.h>
#include <mail/sendbernar/server/include/remind_message_sender.h>
#include <mail/sendbernar/server/include/fwd.h>
#include <mail/sendbernar/core/include/composed_message.h>
#include <mail/sendbernar/composer/include/delivery_helpers.h>
#include <macs/label.h>


namespace sendbernar::server::callbacks {

boost::optional<macs::Envelope> getEnvelope(MetadataPtr metadata,
                                            const macs::Label& label,
                                            const std::string& msgId) {
    const auto items = metadata->getEnvelopesWithNoAnswer(msgId, label.lid());
    return items.size() == 1 ? boost::make_optional(items[0]) : boost::none;
}

void NoAnswerRemindHandler::doSendbernar(Context& ctx, const Account&,
                                         params::CommonParams common, MetadataPtr metadata) const {
    const auto p = getNoAnswerRemindCallback(ctx);

    const macs::Label remindLabel = metadata->labelBySymbol(macs::Label::Symbol::remindNoAnswer_label);
    const auto envelope = getEnvelope(metadata, remindLabel, p.message_id);

    if (!envelope) {
        LOGDOG_(ctx.logger, notice, log::message="no_answer_remind is obsolete for message_id=" + p.message_id);
        ctx.responseWith(NoAnswerRemindCallbackResponse());
        return;
    }

    const std::string messageId = "<" + envelope->mid() + ".remind_noanswer@mail.yandex.ru>";

    RemindMessageSender sender(common, sendConfig()->reminders().noAnswerTemplates, ctx, sendConfig());


    mail_errors::error_code e = sender.messageId(messageId)
            .date(p.date)
            .to(envelope->from())
            .inReplyTo(p.message_id)
            .lang(p.lang)
            .composeAndSend(metadata->labelBySymbol(macs::Label::Symbol::notifyNoAnswer_label), *envelope);

    if (e) {
        ctx.responseWith(e);
        return;
    }

    LOGDOG_(ctx.logger, notice, log::message="no_answer_notify has been sent for message_id=" + p.message_id);
    metadata->unmarkEnvelopes(envelope->mid(), {remindLabel});

    ctx.responseWith(RemindMessageCallbackResponse());
}

}

SBR_HANDLER_IMPL(sendbernar::server::callbacks, NoAnswerRemindHandler)
