#include <mail/sendbernar/server/include/handlers/cancel_send_delayed.h>
#include <mail/sendbernar/server/include/fwd.h>
#include <mail/sendbernar/services/include/delayed.h>
#include <user_journal/parameters/mailbox.h>
#include <mail_getter/attachment_storage.h>

namespace sendbernar::server::handlers {

void CancelSendDelayed::doSendbernar(Context& context, const Account&, params::CommonParams common,
                                     MetadataPtr metadata) const {
    const auto params = getCancelSendDelayed(context);
    const auto errorCode = deleteReminder(common.uid, params.mid, metadata, context.logger, context.http);
    if (errorCode) {
        context.responseWith(errorCode);
    } else {
        CancelSendDelayedResponse response;

        try {
            moveMessage(params.mid, metadata);
            remarkEnvelope(params.mid, metadata);

            response.allDone = true;
        } catch (const std::exception& ex) {
            LOGDOG_(context.logger, error, log::message="an exception during cleanup",
                    log::exception=ex);
        }

        context.responseWith(response);

        using namespace user_journal::parameters;

        auto journal = config_->maildb->journal(
            serviceParams(common),
            journalParams(getUserJournalParams(context))
        );

        journal.write<UndoSending>(
            id::state(""),
            id::affected(1ul),
            id::mdb("pg"),
            id::mid(params.mid));
    }
}

mail_errors::error_code CancelSendDelayed::deleteReminder(const params::Uid& uid, const params::Mid& mid,
                                                          MetadataPtr metadata, ContextLogger logger, const http_getter::TypedClient& http) const {
    params::Message message{.source_mid = mid};
    return deleteDelayedReminderSync(uid, SourceMid(message, metadata, logger), http, sendConfig());
}

void CancelSendDelayed::remarkEnvelope(const params::Mid& mid, MetadataPtr metadata) const {
    const auto delayed = metadata->labelBySymbol(macs::Label::Symbol::delayedMessage_label);
    const auto undo = metadata->labelBySymbol(macs::Label::Symbol::undoMessage_label);
    const auto draft = metadata->labelBySymbol(macs::Label::Symbol::draft_label);
    metadata->markEnvelopes({mid}, {draft});
    metadata->unmarkEnvelopes(mid, {delayed, undo});
}

void CancelSendDelayed::moveMessage(const params::Mid& mid, MetadataPtr metadata) const {
    const auto destFid = metadata->fidBySymbol(macs::Folder::Symbol::drafts);
    metadata->moveMessage(destFid, mid);
}

}

SBR_HANDLER_IMPL(sendbernar::server::handlers, CancelSendDelayed)
